//Source file: F:\jschwartz\src\Alkindi\BusinessDataTypes\Recommendation.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.Data;

import java.io.Serializable;

/* 
$Header: Recommendation.java, 12, 5/3/01 10:10:02 AM, Schwartz, Joe$
$Log: 
 12   Alkindi Development1.11        5/3/01 10:10:02 AM   Schwartz, Joe   Added
      extra fields for scoring function and prod cluster.
 11   Alkindi Development1.10        2/23/01 4:34:51 PM   Schwartz, Joe  
      Changed constructors to accomodate float evaluations.
 10   Alkindi Development1.9         12/28/00 1:06:54 PM  Schwartz, Joe   Added
      version control header info.
 9    Alkindi Development1.8         12/26/00 7:21:17 PM  Schwartz, Joe   
 8    Alkindi Development1.7         12/26/00 6:57:25 PM  Schwartz, Joe   
 7    Alkindi Development1.6         12/18/00 6:08:37 PM  Schwartz, Joe   
 6    Alkindi Development1.5         12/18/00 12:05:40 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 5    Alkindi Development1.4         11/14/00 12:53:15 PM Schwartz, Joe   
 4    Alkindi Development1.3         10/30/00 7:52:23 PM  Schwartz, Joe   
 3    Alkindi Development1.2         10/19/00 1:12:17 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 2    Alkindi Development1.1         10/6/00 4:13:42 PM   Schwartz, Joe   
 1    Alkindi Development1.0         9/21/00 4:11:13 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * A recommendation of a specific product.
 */
public class Recommendation extends Rating implements Serializable 
{
	
	/**
	 * The overall average evaluation of the recommended product.
	 */
	public float averageEval;
	
	/**
	 * The Scoring Function used to obtain the recommendation. Defaults to zero.
	 */
	public int scoreFuncID = 0;
	
	/**
	 * The Product Cluster from which the recommended Product was selected. Defaults to zero.
	 */
	public int prodClusterID = 0;
	
	/**
	 * Returns the predicted rating of the product for the user to whom it is being recommended.
	 * @roseuid 3A3E3BA60222
	 */
	public float predictedRating() 
	{
		return evaluation;
	}
	
	/**
	 * Basic constructor for the Recommendation object.
	 * @param who The user to whom this recommendation belongs.
	 * @param what The product to be recommended.
	 * @param predRating The user's predicted evaluation of the recommended product.
	 * @param avgEval The overall average evaluation of the product.
	 * @roseuid 3A3E3BC8034B
	 */
	public Recommendation(final SystemUser who, final Product what, final float predRating, final float avgEval) 
	{
		super(who, what, predRating);
		averageEval = avgEval;
	}
	
	/**
	 * Extended constructor for the Recommendation object.
	 * @param who The user to whom this recommendation belongs.
	 * @param what The product to be recommended.
	 * @param predRating The user's predicted evaluation of the recommended product.
	 * @param avgEval The overall average evaluation of the product.
	 * @param sfID The Scoring Function used to obtain the Recommendation.
	 * @param pcID The ProductCluster used to obtain the Recommendation.
	 * @roseuid 3AF16167038A
	 */
	public Recommendation(final SystemUser who, final Product what, final float predRating, final float avgEval, final int sfID, final int pcID) 
	{
		super(who, what, predRating);
		averageEval = avgEval;
		scoreFuncID = sfID;
		prodClusterID = pcID;
	}
}
